/*

 Chunk Expression Library for C++
 (c) 2004 Jonathan Bettencourt / Kreative Korporation

 This is pretty self-explanatory. For help on how to use this or what it does,
 see the man page for the cxl command line utility and/or the section on chunk
 expressions in the HyperCard Script Language Guide.


 This code is under the MIT license.

 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in the
 Software without restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
 Software, and to permit persons to whom the Software is furnished to do so,
 subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies
 or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef _____CHUNKEXPRESSIONLIB_____
#define _____CHUNKEXPRESSIONLIB_____

#include <string>
#include <vector>
#include "stringmaniplib.h"
using namespace std;

/* the following are defined in chunkexpressionlib.cpp, not in the header file */
/*char cxl_element_delimiter = 127;
char cxl_item_delimiter = ',';
char cxl_list_delimiter = 8;
vector<char> cxl_delimiter_stack;
union cxl_x_hasher
{
	char char_value[4];
	long int hash_value;
};*/

class chunk_reference
{
	public:

	string type;
	int start;
	int end;

	chunk_reference(void);
	chunk_reference(const string &, int, int);
	chunk_reference(const chunk_reference &);
	const chunk_reference & operator = (const chunk_reference &);
};

int cxl_cexpr_chunk_end(const string &, const vector<chunk_reference> &);
int cxl_cexpr_chunk_start(const string &, const vector<chunk_reference> &);
string cxl_cexpr_delete_chunk(const string &, const vector<chunk_reference> &);
string cxl_cexpr_get_chunk(const string &, const vector<chunk_reference> &);
vector<chunk_reference> cxl_cexpr_partial_parse(const string &);
string cxl_cexpr_put_into_chunk(const string &, const vector<chunk_reference> &, const string &);
string cxl_cexpr_put_before_chunk(const string &, const vector<chunk_reference> &, const string &);
string cxl_cexpr_put_after_chunk(const string &, const vector<chunk_reference> &, const string &);

int cxl_count_chunks(const string &, const string &);
int cxl_chunk_start(const string &, const string &, int, int);
int cxl_chunk_end(const string &, const string &, int, int);
string cxl_delete_chunk(const string &, const string &, int, int);
string cxl_get_chunk(const string &, const string &, int, int);
string cxl_put_into_chunk(const string &, const string &, int, int, const string &);
string cxl_put_before_chunk(const string &, const string &, int, int, const string &);
string cxl_put_after_chunk(const string &, const string &, int, int, const string &);

int cxl_paragraph_count(const string &);
int cxl_paragraph_start(const string &, int);
int cxl_paragraph_end(const string &, int);
int cxl_sentence_count(const string &);
int cxl_sentence_start(const string &, int);
int cxl_sentence_end(const string &, int);
int cxl_word_count(const string &);
int cxl_word_start(const string &, int);
int cxl_word_end(const string &, int);

bool cxl_x_quote_mark(unsigned char);
bool cxl_x_sentence_ender(unsigned char);
bool cxl_x_whitespace(unsigned char);
bool cxl_x_skippable_a(unsigned char, bool);
bool cxl_x_skippable_b(unsigned char);
int cxl_x_fixStart(int, int, int);
int cxl_x_fixEnd(int, int, int, int);

void cxl_reset_delimiters(void);
void cxl_push_item_delimiter(void);
void cxl_push_element_delimiter(void);
void cxl_push_list_delimiter(void);
void cxl_pop_item_delimiter(void);
void cxl_pop_element_delimiter(void);
void cxl_pop_list_delimiter(void);

inline int cxl_min(int x, int y)
{
	return (x>y)?y:x;
}

inline int cxl_max(int x, int y)
{
	return (x>y)?x:y;
}

inline char cxl_tolower(char c)
{
	return ((c>64)&&(c<91))?c+32:c;
}

inline int cxl_intdivceil(int a, int b)
{
	return ((a%b)==0)?a/b:(a/b)+1;
}

#endif